﻿//////////////////////////////////////////////
// Window.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

typedef struct HWND__* HWND ;

namespace nkImages
{
	class ImageView ;
}

namespace nkMaths
{
	class Point ;
}

namespace nkWinUi
{
	class MenuBar ;
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "Component.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <functional>

/// Class ------------------------------------
	
namespace nkWinUi
{
	class DLL_WINUI_EXPORT Window : public Component
	{
		public :
		
			// Constructor, destructor
			Window (System* system) noexcept ;
			virtual ~Window () ;

			// Getters
			virtual bool isMaximized () const ;
			virtual bool isFullscreen () const ;
			virtual HWND getHwnd () const ;
			virtual nkMemory::String getCanvasId () const ;

			// Setters
			void setMouseLeaveCallback (std::function<void (Window*, nkMaths::Point)> callback) ;
			void setResizeCallback (std::function<void (Window*)> callback) ;
			void setNoBorder (bool value) ;
			virtual void setIcon (const nkImages::ImageView& icon) = 0 ;

			// Size
			virtual void maximize (bool val, bool coverTaskBar = false) = 0 ;

			// Import / Export
			virtual void exportIntrospection (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<Window> create (System* system = nullptr) ;

		protected :

			// Attributes
			// Callbacks
			std::function<void (Window*, nkMaths::Point)> _mouseLeaveCallback ;
			std::function<void (Window*)> _resizeCallback ;

			// Flags
			bool _noBorder ;
	} ;
}